/*
 * pixmap_image.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef PIXMAP_IMAGE_H_
#define PIXMAP_IMAGE_H_

#include "image.h"

class PixmapImage : public BlImage {
private:

private:
  int CreateImage(char* raw, int len);
  int CreatePixmap(char** data);
  char** ParseXpmData(char* raw, int len);
  char* GetNextData(char*& raw, int& len);

protected:
  ~PixmapImage();

public:
  PixmapImage() {}
  PixmapImage(char* raw, int len);
  PixmapImage(char* filename);
  PixmapImage(char** data);
};

#endif // PIXMAP_IMAGE_H_
