/*
 * focus_mgr.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef FOCUS_MGR_H_
#define FOCUS_MGR_H_

#include "list.h"

class Blwm;

/*
 * FocusMgr keeps only non-trasient windows without NOFOCUS.
 * This list stands for an order which a focus moves according to.
 */
class FocusMgr {
private:
  List<Blwm> mapList;
  List<Blwm> unmapList;

public:
  void Push(Blwm* blWm) {
    ASSERT(Check(blWm));
    mapList.InsertHead(blWm);
  }
  Blwm* Pop() { return mapList.RemoveHead(); }

  void InsertBottom(Blwm* blWm) {
    ASSERT(Check(blWm));
    mapList.InsertTail(blWm);
  }
  Blwm* RemoveBottom() { return mapList.RemoveTail(); }

  Bool Remove(Blwm* blWm) { return mapList.Remove(blWm); }

  Blwm* Top() const { return mapList.GetHead(); }
  Blwm* TopUnmapList() const { return unmapList.GetHead(); }

  void InsertUnmapList(Blwm* blWm) { unmapList.InsertTail(blWm); }
  Bool RemoveUnmapList(Blwm* blWm) { return unmapList.Remove(blWm); }

  List<Blwm>& GetMapList() { return mapList; }
  List<Blwm>& GetUnmapList() { return unmapList; }

  int GetAllNum() const { return mapList.GetSize() + unmapList.GetSize(); }

  void SetFocus(Blwm* blWm);
  void ResetFocus(Blwm* blWm);

  void RollFocus(Bool forward);
  void RollFocusWithinScreen(Bool forward);

public:
  void DumpStack();
  Bool Check(Blwm* blWm);
};

#endif // FOCUS_MGR_H_
