/*
 * focus.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "main.h"
#include "misc.h"
#include "blwm.h"
#include "icon.h"
#include "util.h"
#include "blwmrc.h"
#include "focus_mgr.h"
#include "pager.h"

/*
 * SetFocus --
 *   Take off the focus from current focus window, and set the focus to
 *   this window.
 */
void Blwm::SetFocus()
{
  /*
   * Take off the focus of short cut icon, if any.
   */
  if (this != rootBlwm && Icon::focusIcon != NULL)
    Icon::focusIcon->ResetFocus();

  /*
   * If this window has already had the focus, return.
   */
  if (this == focusBlwm)
    return;

  // XXX not enter the focus stack if a NO_FOCUS window and
  // not give it a focus
  if (!CheckFlags(NO_FOCUS)) {
    focusMgr.ResetFocus(focusBlwm);
    focusMgr.SetFocus(this);
  }

  if (UseTaskbar && OnTopTaskbar)
    taskBar->RaiseTaskbar();
  if (UsePager && OnTopPager)
    pager->RaisePager();
}

/*
 * YieldFocus --
 *   Give a focus to another window and move this window to the last of
 *   focus list.
 */
void Blwm::YieldFocus()
{
  // move this window to the bottom of the focus stack
  // do nothing if this window is not in the focus stack
  // (a NO_FUCUS or transient window)
  if (focusMgr.Remove(this))
    focusMgr.InsertBottom(this);

  if (this == focusBlwm) {
    Blwm* tmpBlwm = focusMgr.Top();

    if (tmpBlwm == NULL || tmpBlwm == this)
      tmpBlwm = rootBlwm;
    
    if (ClickToFocus) {
      if (tmpBlwm->CheckMapped()) {
	tmpBlwm->SetFocus();
	tmpBlwm->RaiseWindow(True);
      }
      else
	tmpBlwm->RestoreWindow();
    }
    else
      rootBlwm->SetFocus();
  }
}

void Blwm::SetFocusToActiveWindow()
{
  if (Blwm::focusBlwm == rootBlwm)
    desktop.SetFocus();
  else
    XSetInputFocus(display, Blwm::focusBlwm->GetWin(), RevertToParent,
		   CurrentTime);
}
