/*
 * fbutton.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include "main.h"
#include "misc.h"
#include "blwm.h"
#include "fbutton.h"
#include "blwmrc.h"
#include "pixmap_image.h"
#include "tooltip.h"
#include "bitmaps/button_min.xpm"
#include "bitmaps/button_max.xpm"
#include "bitmaps/button_close.xpm"
#include "bitmaps/button_restore.xpm"

char* FrameButton::desc[4];

BlImage* FrameButton::imgButton[4];

FrameButton::FrameButton(Blwm* blwm, Window parent, const Rect& rc)
: Button(parent, rc), img(NULL), blWm(blwm)
{
  if (TitlebarImage) {
    SetBgImage(Blwm::imgTitlebar, Point(rc.x, rc.y));
    SetBgActiveImage(Blwm::imgActiveTitlebar, Point(rc.x, rc.y));
  }
}

FrameButton::~FrameButton()
{
  BlImage::Destroy(img);
}

void FrameButton::ChangeImage(ButtonName bn)
{
  BlImage::Destroy(img);
  img = imgButton[bn]->Duplicate();
  toolTip->SetString(desc[bn], &fsTitle);
}

/*
 * DrawButton --
 *   Draw frame button.
 */
void FrameButton::DrawButton()
{
  if (blWm->CheckFocus()) {
    if (TitlebarImage)
      imgBack->SetBackground(None);

    if (TitlebarActiveImage)
      imgActiveBack->SetBackground(frame);
    else
      XSetWindowBackground(display, frame, ButtonActiveColor.pixel);
  }
  else {
    if (TitlebarActiveImage)
      imgActiveBack->SetBackground(None);

    if (TitlebarImage)
      imgBack->SetBackground(frame);
    else
      XSetWindowBackground(display, frame, ButtonColor.pixel);
  }

  XClearWindow(display, frame);

  Button::DrawButton();

  if (img) {
    if (state == NORMAL)
      img->Display(frame, Point(2, 2));
    else
      img->Display(frame, Point(3, 3));
  }
}

/*
 * Button1Press --
 *   Process press of button1 (mouse left button)
 */
void FrameButton::Button1Press()
{
  ASSERT(blWm);

  if (!blWm->CheckFocus())
    blWm->SetFocus();

  blWm->RaiseWindow(True);

  Button::Button1Press();
}

/*
 * ExecButtonFunc --
 *   Execute the function of frame button 1 (minimize).
 */
void FrameButton1::ExecButtonFunc(ButtonState bs)
{
  ASSERT(blWm);
  
  if (bs == PUSH)
    blWm->MinimizeWindow();
}

/*
 * ExecButtonFunc --
 *   Execute the function of frame button 2 (maximize or restore).
 */
void FrameButton2::ExecButtonFunc(ButtonState bs)
{
  ASSERT(blWm);

  if (bs == PUSH) {
    if (blWm->CheckStatus(MAXIMIZE_WINDOW)) {
      ChangeImage(MAXIMIZE);
      blWm->RestoreWindow();
    }
    else {
      ChangeImage(RESTORE);
      blWm->MaximizeWindow();
    }
  }
}

/*
 * ExecButtonFunc --
 *   Execute the function of frame button 3 (close window).
 */
void FrameButton3::ExecButtonFunc(ButtonState bs)
{
  ASSERT(blWm);

  if (bs == PUSH)
    BlFunction::execFunction(Q_CLOSE, blWm);
}

void FrameButton::Initialize()
{
  imgButton[MINIMIZE] = new PixmapImage(button_min);
  imgButton[MAXIMIZE] = new PixmapImage(button_max);
  imgButton[CLOSE] = new PixmapImage(button_close);
  imgButton[RESTORE] = new PixmapImage(button_restore);

  desc[MINIMIZE] = MinimizeButtonMessage;
  desc[MAXIMIZE] = MaximizeButtonMessage;
  desc[CLOSE] = CloseButtonMessage;
  desc[RESTORE] = RestoreButtonMessage;
}
