/*
 * desktop.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef DESKTOP_H_
#define DESKTOP_H_

#include "misc.h"
#include "list.h"
#include "taskbar.h"

class Blwm;
class Icon;
class Accessory;
class BlImage;

class Desktop {
private:
  List<Blwm> blwmList;		// window list
  List<Icon> iconList;		// shortcut icon list
  List<Blwm> onTopList;		// on top window list
  List<Accessory> accList;	// accessory list
  
  int initPos;

  BlImage* imgDesktop;

  Window topWin;                // fake window between ontop acc and ontop win

  Colormap curCmap;
  Blwm*	curCmapBlwm;

public:
  Desktop();

  List<Blwm>& GetBlwmList() { return blwmList; }
  List<Icon>& GetIconList() { return iconList; }
  List<Blwm>& GetOnTopList() { return onTopList; }
  List<Accessory>& GetAccList() { return accList; }

  Blwm* LookInList(Window w);
  void CaptureAllWindows();
  Point GetNextPlace(const Dim& size, const Point& pageoff);
  void FinishBlwm(Bool reStart);
  void RecalcAllWindows();
  void ChangeFocusToCursor();
  void SetFocus();

  // Window rearrangement
  void Overlap(Bool all, const Rect& vt);
  void TileHorz(Bool all, const Rect& vt);
  void TileVert(Bool all, const Rect& vt);
  void MinimizeAll(Bool all, const Rect& vt = Rect());
  void RestoreAll(Bool all, const Rect& vt = Rect());
  void CloseAll(Bool all, const Rect& vt = Rect());


  void CreateIcons();
  void RedrawAllIcons();
  void LineUpAllIcons();

  Taskbar::TaskbarPos GetDesktopArea(const Point& pt);

  void SetWallPaper();

  void CreateTopWindow();
  Window GetTopWindow() const { return topWin; }

  void CreateAccessories();

  // colormap
  Blwm* GetCmapInstalled() const { return curCmapBlwm; }
  void SetCmapInstalled(Blwm* blWm) { curCmapBlwm = blWm; }
  Colormap GetCurrentCmap() const { return curCmap; }
  void SetCurrentCmap(Colormap cmap) { curCmap = cmap; }
};

#endif // DESKTOP_H_
