/*
 * debug.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include "main.h"
#include "debug.h"
#ifdef __EMX__
#include <io.h>
#include <string.h>
#endif

#if defined(sun) && !defined(__SVR4)
extern "C" int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
extern "C" int bzero(char *, int);
#endif

Bool Debug::stackTraceDone;

#define PIPE_READ  0
#define PIPE_WRITE 1

void Debug::TraceStack(char* debugger, char* program)
{
  char buf[16];
  char *args[4];

  sprintf(buf, "%d", (int)getpid());

  args[0] = debugger;
  args[1] = program;
  args[2] = buf;
  args[3] = NULL;

  /*
   * Create dual pipe.
   */
  int fdBlwmToDbg[2], fdDbgToBlwm[2];

  if (pipe(fdBlwmToDbg) == -1 || pipe(fdDbgToBlwm) == -1) {
    BlwmError("Can't open pipe");
    return;
  }

  stackTraceDone = False;
  signal(SIGCHLD, TraceStackSigChld);

  pid_t pid;

  if ((pid = fork()) == -1) {
    BlwmError("Can't fork process");
    return;
  }
  else if (pid == 0) {
    /*
     * Redirect stdin/stdout/stderr to pipe.
     */
    close(0);
    dup(fdBlwmToDbg[PIPE_READ]);  // stdin
    close(1);
    dup(fdDbgToBlwm[PIPE_WRITE]);  // stdout
    close(2);
    dup(fdDbgToBlwm[PIPE_WRITE]);  // stderr

    /*
     * Execute the debugger.
     */
    if (execvp(args[0], args) == -1) {
      char str[256];
      sprintf(str, "execv: %s", args[0]);
      perror(str);
    }
    exit(0);
  }

  write(fdBlwmToDbg[PIPE_WRITE], "backtrace\n", 10);
  write(fdBlwmToDbg[PIPE_WRITE], "quit\n", 5);

  while (1) {
    fd_set fds;
    struct timeval tm;
    int s;
    char c;

    FD_ZERO(&fds);
    FD_SET(fdDbgToBlwm[PIPE_READ], &fds);

    tm.tv_sec = 1;
    tm.tv_usec = 0;

#if defined(__hpux) && !defined(_XPG4_EXTENDED)
    s = select(FD_SETSIZE, (int *)&fds, NULL, NULL, &tm);
#else
    s = select(FD_SETSIZE, &fds, NULL, NULL, &tm);
#endif
    if (s <= 0) {
      if (stackTraceDone)
	break;
    }
    else {
      if (FD_ISSET(fdDbgToBlwm[PIPE_READ], &fds))
	if (read(fdDbgToBlwm[PIPE_READ], &c, 1))
	  fprintf(stdout, "%c", c);
    }
  }

  close(fdBlwmToDbg[PIPE_READ]);
  close(fdBlwmToDbg[PIPE_WRITE]);
  close(fdDbgToBlwm[PIPE_READ]);
  close(fdDbgToBlwm[PIPE_WRITE]);

  return;
}

void Debug::TraceStackSigChld(int sig)
{
  stackTraceDone = True;

  wait(NULL);
}
