/*
 * confirm_dialog.cc
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "confirm_dialog.h"
#include "resource.h"
#include "blwm.h"

ConfirmDialog::ConfirmDialog()
: SystemDialog()
{
  Rect rcText(25, 20, -1, -1);
  char* text = "Alguns aplicativos esto em execuo. Realmente sair?";
  Rect rcYesButton(109, 50, 88, 23);
  Rect rcNoButton(204, 50, 88, 23);
  DialogRes* dr[3];

  dr[0] = new DialogRes(STATICTEXT, NO_ID, rcText, text, fsDialog);
  dr[1] = new DialogRes(STRINGBUTTON, ID_OK, rcYesButton, "\\&Sim",
			fsDialog);
  dr[2] = new DialogRes(STRINGBUTTON, ID_CANCEL, rcNoButton, "\\&Nao",
			fsDialog);

  CreateDialogResource(dr, 3);

  for (int i = 0; i < 3; i++)
    delete dr[i];

  Rect rcRoot = rootBlwm->GetRect();
  Rect rect((rcRoot.width - ConfirmDlgWidth) / 2,
	    (rcRoot.height - ConfirmDlgHeight) / 2,
	    ConfirmDlgWidth, ConfirmDlgHeight);
  
  SetRect(rect);
  SetTitle("Confirmao");
}

void ConfirmDialog::ProcessDialog()
{
  ResourceId id;

  XGrabServer(display);

  id = EventLoop();

  XUngrabServer(display);
  UnmapDialog();
  RefreshScreen();

  if (id == ID_OK)
    FinishBlwm();
}
