/*
 * callback.h
 *
 * Copyright (C) 1995, 1996, 1997, 1997, 1998, 1999, 2000, 2001, 2002 Kenichi Kourai
 * Copyright (C) 1999, 2000, 2001, 2002 Luiz Blanes
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with blwm; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef CALLBACK_H_
#define CALLBACK_H_

class BasicCallback {
public:
  virtual void Execute() = 0;

  virtual Bool Equal(BasicCallback* cb) = 0;
};

template <class T>
class Callback : public BasicCallback {
  typedef void (T::*FuncPtr)();

private:
  T* obj;
  FuncPtr func;

public:
  Callback(T* o, FuncPtr f) : obj(o), func(f) {}

  void Execute() { (obj->*func)(); }

  Bool Equal(BasicCallback* bcb) {
    Callback<T>* cb = (Callback<T> *)bcb;
    if (obj == cb->obj && func == cb->func)
      return True;
    return False;
  }
};

class GlobalCallback : public BasicCallback {
  typedef void (*FuncPtr)();

private:
  FuncPtr func;

public:
  GlobalCallback(FuncPtr f) : func(f) {}

  void Execute() { (*func)(); }

  Bool Equal(BasicCallback* bcb) {
    GlobalCallback* cb = (GlobalCallback *)bcb;
    if (func == cb->func)
      return True;
    return False;
  }
};

#endif // CALLBACK_H_
